% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022
% 
% Running this code updates files that are used to create Figures and Tables
% in the paper. 
% Note that the figures and tables are created using the MASTER_FIGURES.m
% and MASTER_TABLES.m files in the directory ".../Replication package/Figures" 
% and ".../Replication package/Tables"


clear
close all
clc

% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 
% % % % % % NOTE: Set your working directory here:
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

REP_PATH        = '/.../Replication package';

PARMS.direc     = sprintf('%s/Matlab',REP_PATH); % Matlab sub-directory
PARMS.resfolder = sprintf('%s/results',PARMS.direc); % results sub-directory
PARMS.figfolder = sprintf('%s/Figures/Figures_data',REP_PATH); % Figure output sub-directory
PARMS.tabfolder = sprintf('%s/Tables/Tables_data',REP_PATH); % Table output sub-directory
cd(PARMS.direc)

%% Externally set parameters

% Pre-determined parameters
PARMS.B         = 0.9615; % discount rate (annual frequency)
PARMS.GAMMA     = 1; % utility parameter (1==log)
PARMS.ALPHA     = 0.81; % Cobb-Douglas parameter for capital in revenue function
PARMS.DELTA     = 0.10; % depreciation rate

PARMS.N         = 11; % number of productivity states
PARMS.lg        = 11; % Number of MU & PHI grid points (each)
lenpi           = 1000; % Grid points for PI
PARMS.PI        = linspace(0,1,lenpi)'; % PI-grid

%% Calibrated parameters for steady state

PARMS.rho_eps   = .9304807665; % AR(1) of eps
PARMS.sigma_eps = .4326043886; % sigma of eps
PARMS.F_upper   = .1689333554; % upper bound of adjustment cost distribution

%% Solve the steady state given parameters
[~, PARMS, steady]  = steady_state(PARMS);

% Update output for tables and figures
% To update, set switch to 1
if 1 == 0
    Table_2_create_modeloutput
    Figure_3_create_data
end

%% Aggregate fluctuations

%% A model 
% Run the model 
PARMS.sigA      = .0150969279;
PARMS.rhoA      = .6552030451;

% Save model moments for tables, as well as IRF for plots
solve_agg(PARMS,steady,'A');

%% F model 
% Run the model 
PARMS.sigF      = .0436944274;
PARMS.rhoF      = .9483523990;

% Save model moments for tables, as well as IRF for plots
solve_agg(PARMS,steady,'F');

%% Model with aggregate capital

% Different parameters
PARMS.sigma         = .4326009346;
PARMS.F_upper       = .0241000068;
PARMS.rho_eps       = .9304795860;
PARMS.sigA          = .0150969279;
PARMS.rhoA          = .6552030451;

solve_K_model

%% Robustness: 

%% 1) Results from baseline model with ALPHA = 0.7

PARMS.ALPHA         = 0.7;
PARMS.rho_eps       = .8957275527; % AR(1) of eps
PARMS.sigma_eps     = .3732858680; % sigma of eps
PARMS.F_upper       = .1025244780; % upper bound of adjustment cost distribution

[~, PARMS, steady]  = steady_state(PARMS);

% With aggregate shocks:
% A model
PARMS.sigA      = .0168207396;
PARMS.rhoA      = .7020781837;

% Save model moments for tables, as well as IRF for plots
solve_agg(PARMS,steady,'A',0);

% F model
PARMS.sigF      = .1017174767;
PARMS.rhoF      = .9898875711;

% Save model moments for tables, as well as IRF for plots
solve_agg(PARMS,steady,'F',0);


%% 2) Sensitivity with respect to steady state parameters
% This produces the output for Table D.5 in the Appendix

Table_D5_create_modeloutput





